import os
import re
from pathlib import Path

def extract_ed2k_links_between_markers(file_path):
    with open(file_path, 'r', encoding='utf-8', errors='ignore') as f:
        content = f.read()

    # 用正則擷取兩個標記中間的段落
    match = re.search(
        r'115壓縮包格式離綫下載地址：([\s\S]*?)115視頻格式離綫下載地址：',
        content
    )

    if match:
        section = match.group(1)
        links = re.findall(r'ed2k://\S+', section)
        for link in links:
            print(link)

def search_all_txt_files_and_extract_links(root_dir):
    root_path = Path(os.path.expanduser(root_dir))
    for txt_file in root_path.rglob('*.txt'):
        extract_ed2k_links_between_markers(txt_file)

# ✅ 指定目錄
search_all_txt_files_and_extract_links('~/Downloads/彩月七緒/')
